Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 70.38, y = 146.34, z = 5, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 10, 
	position = { x = 167.0, y = 65.5, z = 15.1, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["army_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_army_set", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

Triggers["emergency_exit"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_emergency_exit", 
	type = "quest", 
}

Triggers["patrol_1"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 22, 
	point_radius = 0.5, 
	position = { y=57.9, x=7.4, z=14.3, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 10, 
	patrol_points = {{ x=7.36666, y=57.8617, z=14.2718},{ x=6.942, y=46.0598, z=12.9599},{ x=18.3682, y=41.2619, z=10.5151},{ x=32.7627, y=40.7714, z=9.43024},{ x=36.7036, y=30.7544, z=8.94035},{ x=28.3217, y=18.9019, z=8.15831},{ x=22.9047, y=10.6735, z=7.48727},{ x=29.2847, y=0.742197, z=7.2401},{ x=40.1038, y=0.0360528, z=6.6634},{ x=51.7138, y=-0.98431, z=5.751},{ x=59.7687, y=-8.20365, z=4.67994},{ x=71.1632, y=-12.5909, z=4.71131},{ x=80.9778, y=-12.3355, z=7.33806},{ x=101.721, y=2.03251, z=7.15905},{ x=115.857, y=0.892774, z=7.64955},{ x=133.663, y=14.7038, z=9.27291},{ x=134.301, y=23.5266, z=9.84313},{ x=120.95, y=29.6141, z=9.3017},{ x=120.752, y=39.3041, z=10.3279},{ x=124.441, y=45.4891, z=10.8724},{ x=133.773, y=49.6145, z=12.1742},{ x=135.728, y=59.0668, z=14.2163} }
}

Triggers["patrol_10"] = 
{
	color = "0xAA00AA", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 4, 
	point_radius = 0.5, 
	position = { y=80.2, x=3.9, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 5, 
	patrol_points = {{ x=3.85419, y=80.1949, z=13.8542},{ x=-33.9683, y=82.328, z=13.7461},{ x=-33.3911, y=142.747, z=13.9929},{ x=1.24614, y=143.209, z=13.8477} }
}

Triggers["patrol_2"] = 
{
	color = "0xFF00FF", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 5, 
	point_radius = 0.5, 
	position = { y=62.1, x=40, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 5, 
	patrol_points = {{ x=39.9699, y=62.0644, z=13.8612},{ x=65.2203, y=67.4552, z=13.8657},{ x=83.7657, y=63.667, z=13.8657},{ x=104.602, y=62.5448, z=13.8657},{ x=116.36, y=62.0975, z=13.8649} }
}

Triggers["patrol_3"] = 
{
	color = "0xFFFF00", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 6, 
	point_radius = 0.5, 
	position = { y=69.5, x=142.6, z=14.4, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "last", 
	wait_time = 15, 
	patrol_points = {{ x=142.595, y=69.5318, z=14.3842},{ x=141.472, y=86.3497, z=14.7148},{ x=144.04, y=114.144, z=14.7946},{ x=125.231, y=119.929, z=14.1734},{ x=117.934, y=126.628, z=12.8972},{ x=112.516, y=128.303, z=11.8589} }
}

Triggers["patrol_4"] = 
{
	color = "0x0000FF", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 4, 
	point_radius = 0.5, 
	position = { y=126.7, x=149, z=15.2, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 5, 
	patrol_points = {{ x=149.01, y=126.668, z=15.1921},{ x=142.208, y=135.873, z=14.2819},{ x=129.064, y=128.415, z=14.2743},{ x=135.065, y=118.743, z=14.2746} }
}

Triggers["patrol_5"] = 
{
	color = "0x00FFFF", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 5, 
	point_radius = 0.5, 
	position = { y=68.3, x=125.1, z=14.2, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 10, 
	patrol_points = {{ x=125.081, y=68.331, z=14.1654},{ x=120.504, y=83.5027, z=14.2878},{ x=123.381, y=95.8824, z=14.171},{ x=124.068, y=109.862, z=14.0917},{ x=129.957, y=118.168, z=14.2746} }
}

Triggers["patrol_6"] = 
{
	color = "0x00FF00", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 7, 
	point_radius = 0.5, 
	position = { y=67.9, x=37.4, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 5, 
	patrol_points = {{ x=37.3507, y=67.895, z=13.8543},{ x=37.9632, y=81.786, z=13.8542},{ x=31.2407, y=83.0234, z=13.8542},{ x=24.4944, y=90.6978, z=13.8541},{ x=25.1839, y=106.732, z=13.8123},{ x=21.6494, y=114.744, z=13.8469},{ x=18.3331, y=140.534, z=13.8542} }
}

Triggers["patrol_7"] = 
{
	color = "0xFF00AA", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 6, 
	point_radius = 0.5, 
	position = { y=143.1, x=8.2, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 10, 
	patrol_points = {{ x=8.21757, y=143.083, z=13.8542},{ x=2.32284, y=139.87, z=13.8498},{ x=-0.410275, y=126.277, z=13.8002},{ x=5.51845, y=112.793, z=13.8542},{ x=5.42854, y=96.1468, z=13.8542},{ x=9.85355, y=80.8562, z=13.8542} }
}

Triggers["patrol_8"] = 
{
	color = "0xFFAA00", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "circle", 
	point_count = 4, 
	point_radius = 0.5, 
	position = { y=95.1, x=0.2, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "each", 
	wait_time = 5, 
	patrol_points = {{ x=0.230656, y=95.0773, z=13.932},{ x=-1.48208, y=127.225, z=13.7874},{ x=-27.7344, y=127.662, z=13.9186},{ x=-28.5348, y=95.9117, z=13.8086} }
}

Triggers["patrol_9"] = 
{
	color = "0xAAAA00", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 3, 
	point_radius = 0.5, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "first_and_last", 
	wait_time = 5, 
	patrol_points = {{ x=9.80345, y=77.6377, z=13.8542},{ x=-7.45503, y=77.4666, z=13.9524},{ x=-31.7801, y=76.9636, z=14.1203} }
}

Triggers["mission"] = 
{
	active = true, 
	effect_radius = 3, 
	position = { y=64.02, x=139.33, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_mission", 
	type = "quest", 
}

trigger_functions =
{
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id, PLAYER) ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if ARMY == Sectors.dam.owner then
			Triggers["army_set"].active = true
			Triggers["mission"].active = true			
		end	
		
		Sectors[CUR_MISSION.Name].onUpdate()
		trigger.active = false
	end
end,
tf_army_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, ARMY)
		setGVAR("GLOBAL_WAR_BEGAN", _YES)	
		trigger.active = false
	end
end,	
tf_emergency_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		finishMission()
		trigger.active = false
	end
end,	
tf_mission = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if (trigger.active == true) then
	
		if (Sectors.dam.isDone) then
			return
		end

		if ( (trigger.active == true) and (ARMY == Sectors.dam.owner) and (getGVAR("GLOBAL_WAR_BEGAN") == _NO) ) then
			if ( getGVAR("spawn_patrol_da") == _YES ) then
				if ( healthOK("officer_1") ) then
					checkPointer("dam", trigger_id, {"officer_1"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false, 7)
				end
				if ( healthOK("patrol_1") ) then
					checkPointer("dam", trigger_id, {"patrol_1", "patrol_2", "patrol_3"}, "checkpoint_remark1", "checkpoint_remark2", "docu_check", 10, time, true, 30, "checkpoint_remark3", false, 7)
				end
			end
		end
		
		return							
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
